%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Lego Dataset - Example code to plot non-dimensional velocity profiles
% Created by Dr Marco Placidi (Mar 2019)
% DOI: 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

close all
clear
clc

% loading CaseID data
load PLANAR_5LF_FIL                                     

% plotting mean velocity profiles and turbulence statistics
figure(1)
set(gcf,'units','points','position',[0,0,1800,500])
subplot(1,4,1)
plot(U./U_edge,Y./delta,'k','linewidth',2)
xlabel ({'$U/U_e$'}, 'FontSize',20,'Interpreter','latex');
ylabel({'$y/\delta$'},'FontSize',20,'Interpreter','latex');
set(gca,'Fontsize',20)
title('Mean velocity profile','FontSize',20,'Interpreter','latex')

subplot(1,4,2)
semilogx(Y./delta,uu./utau.^2,'k','linewidth',2);
ylabel ({'$${\overline{u''u''}}/{u_{\tau}}^2$$'}, 'FontSize',20,'Interpreter','latex');
xlabel({'$y/\delta$'},'FontSize',20,'Interpreter','latex');
set(gca,'Fontsize',20)
title('Streamwise fluctuations','FontSize',20,'Interpreter','latex')

subplot(1,4,3)
semilogx(Y./delta,vv./utau.^2,'k','linewidth',2);
ylabel ({'$${\overline{v''v''}}/{u_{\tau}}^2$$'}, 'FontSize',20,'Interpreter','latex');
xlabel({'$y/\delta$'},'FontSize',20,'Interpreter','latex');
set(gca,'Fontsize',20)
title('Wall-normal fluctuations','FontSize',20,'Interpreter','latex')

subplot(1,4,4)
semilogx(Y./delta,-uv./utau.^2,'k','linewidth',2);
ylabel ({'$${-\overline{u''v''}}/{u_{\tau}}^2$$'}, 'FontSize',20,'Interpreter','latex');
xlabel({'$y/\delta$'},'FontSize',20,'Interpreter','latex');
set(gca,'Fontsize',20)
title('Reynolds shear stresses','FontSize',20,'Interpreter','latex')